<?php

// ====================================================================================
// SHORTCODE [chatlist user="X"] – lista hilos del usuario X (del más reciente al más viejo)
// ====================================================================================
add_shortcode("chatlist", function ($atts) {
    $atts = shortcode_atts(array(
        "user" => 0
    ), $atts, "chatlist");

    // Validar el usuario a listar
    $uid = intval($atts["user"]);
    if ($uid == 0) {
        return "<div>Invalid chat list, use [chatlist user=\"ID\"].</div>";
    }

    global $wpdb;

    // Nombre de tabla (misma usada por el chat)
    $table = $wpdb->prefix . "simple_chats";

/*/ Construir lista de hilos únicos por pareja (min,max) y su última fecha
$sql = "
    SELECT 
        chat_key,
        LEAST(sender_id, receiver_id) AS u_min,
        GREATEST(sender_id, receiver_id) AS u_max,
        MAX(created_at) AS last_at
    FROM {$table}
    WHERE sender_id = %d OR receiver_id = %d
    GROUP BY LEAST(sender_id, receiver_id), GREATEST(sender_id, receiver_id)
    ORDER BY last_at DESC
";/**/
$sql = "
    SELECT 
        IF(sender_id = %d, receiver_id, sender_id) AS other_user_id,
        COALESCE(post_id, 0) AS post_id,
        MAX(created_at) AS last_at
    FROM {$table}
    WHERE sender_id = %d OR receiver_id = %d
    GROUP BY other_user_id, COALESCE(post_id, 0)
    ORDER BY last_at DESC
";

$threads = $wpdb->get_results($wpdb->prepare($sql, $uid, $uid, $uid), ARRAY_A);
// Nota: quitamos el filtro de hilos fantasma basado en u_min/u_max porque ya no usamos esas columnas

/*/$threads = $wpdb->get_results($wpdb->prepare($sql, $uid, $uid), ARRAY_A);
// filtrar hilos fantasma en PHP, cuando el admin interviene
$threads = array_values(array_filter($threads, function($r){
    $u_min = intval($r["u_min"]);
    $u_max = intval($r["u_max"]);
    $expected = $u_min . "-" . $u_max;
    return isset($r["chat_key"]) && $r["chat_key"] == $expected;
}));/**/

    // Comenzar salida HTML
    $out  = '<div class="soc-chatlist-wrap" data-uid="' . $uid . '">';
    // Contenedor para la lista
    $out .= '<ul class="soc-chatlist">';

    if (!empty($threads)) {
        foreach ($threads as $r) {
                        
            /*/ Determinar el "otro" usuario en la pareja
            $u_min = intval($r["u_min"]);
            $u_max = intval($r["u_max"]);
            $other = ($u_min == $uid) ? $u_max : ($u_max == $uid ? $u_min : 0);/**/
            $other = intval($r["other_user_id"]);
            
            if ($other == 0) {
                // si no se puede determinar el otro usuario, saltar
                continue;
            }

            // Obtener un nombre para mostrar (lo resolverás como prefieras)
            // ejemplo con display_name de WP_User
            $u = get_user_by("id", $other);
            $name = $u ? $u->display_name : "User " . $other;

            // Resolver post_id y etiqueta del post
            $pid = intval($r["post_id"]); // 0 => General
            $postLabel = "General";
            $postHtml  = "General";
            if ($pid > 0) {
                $t = get_the_title($pid);
                if ($t && $t != "") {
                    $postLabel = $t;
                    $postHtml = "<a href=\"".esc_url(get_permalink($pid))."\" target=\"_blank\" rel=\"noopener\" class=\"soc-linkpost\">".esc_html($t)."</a>";
                }
            }
            
            // Shortcode a ejecutar (mostrar literal, NO ejecutarlo)
            //$openSC = "[chat from=\"" . $uid . "\" to=\"" . $other . "\"]";
            $openSC = "[chat from=\"" . $uid . "\" to=\"" . $other . "\" post=\"" . $pid . "\"]";
            // obtener chat_key del par
            $chat_key = soc_normalize_chat_key($uid, $other);

$reported_html = "";
if (isset($chat_key) ) {
    if (soc_is_reported($chat_key, $pid)) {  
        $reported_html = '<div class="soc-reported-note">Reported, our team is investigating</div>';
    }else{
        $reported_html = '<a href="#" class="soc-open-chat" data-from="' . $uid . '" data-to="' . $other . '" aria-expanded="false">Read</a>';
    }
}
            
            // render por item, se oculta inicialmente; esto evita AJAX y permite acordeón
            $out .= '<li class="soc-thread-item" data-chat-key="' . esc_attr($chat_key) . '" data-last-at="' . esc_attr($r["last_at"]) . '">'
                 .  '<strong>' . esc_html($name)." - " .$postHtml. '</strong>'
                 .  '<span class="soc-last"> · <em>Last:</em> ' . esc_html($r["last_at"]) . ' · </span> '
. $reported_html
//                 .  '<div class="soc-hint">Using: <code>' . esc_html($openSC) . '</code></div>' // mostrar literal del shortcode
                 .  '<div class="soc-chat-thread" style="display:none;">' . do_shortcode($openSC) . '</div>' // contenedor acordeón
                 .  '</li>';
        }
    } else {
        $out .= '<li>No messages.</li>';
    }

    $out .= '</ul>';

    // Script para acordeón (hide/show por item y cierre de los demás)
    $out .= '<script>jQuery(document).ready(function ($) {
        
        // Delegamos por si la lista cambia dinámicamente
        $(".soc-chatlist-wrap").on("click", ".soc-open-chat", function (e) {
            e.preventDefault(); // Evita salto de página

            // Contenedor de este hilo
            var $li = $(this).closest(".soc-thread-item"); // item actual
            var $thread = $li.find(".soc-chat-thread");    // chat embebido de este item

            // Cerrar cualquier otro abierto en la misma lista
            $li.siblings().find(".soc-chat-thread:visible").slideUp(200);
            $li.siblings().find(".soc-open-chat[aria-expanded=true]").attr("aria-expanded", "false").text("Read");

            // Toggle del actual
            if ($thread.is(":visible")) {
                // Si está abierto, cerramos
                $thread.slideUp(200);
                $(this).attr("aria-expanded", "false").text("Read");
            } else {
                // Si está cerrado, abrimos
                $thread.slideDown(200);
                $(this).attr("aria-expanded", "true").text("Close");
            }

            // Nota: el chat ya está renderizado con do_shortcode()
            //       por eso no hacemos llamadas AJAX aquí.
        });

    });</script>';
        
    return $out;
});
